var __extends = this.__extends || function (d, b) {
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MemoryAnalyzer;
(function (MemoryAnalyzer) {
    var SummaryViewController = (function () {
        function SummaryViewController(memoryAnalyzer, storageId, isOffline) {
            this._screenshotWidth = 200;
            this._screenshotHeight = 150;
            this._screenshotKeepAspectRatio = true;
            this._memoryAnalyzer = memoryAnalyzer;
            this._storageId = storageId;
            this._session = MemoryAnalyzer.Extensions.Session;
            this.model = new SummaryViewModel(isOffline);
            this.view = new SummaryView(this, this.model);
        }
        SummaryViewController.NextIdentifier = 0;
        SummaryViewController.prototype.loadExistingSnapshots = function () {
            var _this = this;
            var fileExtension = ".snapjs.snapshotsummary";
            var storage = new MemoryAnalyzer.Extensions.Storage(this._storageId);
            var snapshotSummaries = [];
            var snapshotCount = 0;
            storage.getListing().then(function (files) {
                files = files.filter(function (file) {
                    return file.slice(-fileExtension.length) === fileExtension;
                });
                for(var i = 0; i < files.length; i++) {
                    MemoryAnalyzer.SnapshotSummary.load(_this._storageId, files[i], function (snapshotNumber, snapshotSummary) {
                        snapshotSummaries.push(snapshotSummary);
                        snapshotCount++;
                        if(snapshotCount === files.length) {
                            snapshotSummaries = snapshotSummaries.sort(function (a, b) {
                                return a.id - b.id;
                            });
                            for(var snapshot = 0; snapshot < snapshotSummaries.length; snapshot++) {
                                this.model.snapshotSummaryCollection.add(snapshotSummaries[snapshot]);
                            }
                        }
                    }.bind(_this, i), _this.onSnapshotFailed.bind(_this));
                }
                MemoryAnalyzer.Program.onIdle();
            }, this.onSnapshotFailed.bind(this));
        };
        SummaryViewController.prototype.save = function () {
            if(this.model.snapshotSummaryCollection.length > 0) {
                return this._session.save(true);
            }
            return Plugin.Promise.as(null);
        };
        SummaryViewController.prototype.startGraph = function () {
            if(this.model.isShowingHeapGraph) {
                this._memoryAnalyzer.callProxy("getTargetProcessId", [], this.onProcessIdResult.bind(this));
            }
        };
        SummaryViewController.prototype.stopGraph = function () {
            if(this._heapDataController) {
                this._heapDataController.stop();
            }
        };
        SummaryViewController.prototype.takeSnapshot = function () {
            if(this.model.isTakingSnapshot) {
                return;
            }
            this.model.isTakingSnapshot = true;
            var args = [];
            args.push(this._screenshotWidth);
            args.push(this._screenshotHeight);
            args.push(this._screenshotKeepAspectRatio);
            this._memoryAnalyzer.callProxy("createSnapshot", args, this.onSnapshotResult.bind(this));
        };
        SummaryViewController.prototype.cancelPendingSnapshots = function () {
            this.terminateProcessor();
        };
        SummaryViewController.prototype.viewSnapshot = function (snapshotId, target) {
            var foundSnapshotSummary = this.getSnapshotSummary(snapshotId);
            if(foundSnapshotSummary) {
                this._memoryAnalyzer.showSnapshotTab(foundSnapshotSummary.snapshotFile.relativePath, target, Plugin.Resources.getString("SnapshotNumber", foundSnapshotSummary.id));
            }
        };
        SummaryViewController.prototype.compareSnapshots = function (lastSnapshotId, firstSnapshotId, target) {
            if(lastSnapshotId < firstSnapshotId) {
                var tempId = lastSnapshotId;
                lastSnapshotId = firstSnapshotId;
                firstSnapshotId = tempId;
            }
            var snapshotsInfo = [];
            var lastSnapshotInfo = this.getSnapshotSummary(lastSnapshotId);
            var firstSnapshotInfo = this.getSnapshotSummary(firstSnapshotId);
            if(lastSnapshotInfo && firstSnapshotInfo) {
                for(var i = 0; i < this.model.snapshotSummaryCollection.length; i++) {
                    var s = this.model.snapshotSummaryCollection.getItem(i);
                    if(s.taken >= firstSnapshotInfo.taken && s.taken <= lastSnapshotInfo.taken) {
                        snapshotsInfo.push(s);
                    }
                }
                snapshotsInfo = snapshotsInfo.sort(function (a, b) {
                    return a.taken - b.taken;
                });
            }
            var snapshotFiles = [];
            for(var i = 0; i < snapshotsInfo.length; i++) {
                snapshotFiles.push(snapshotsInfo[i].snapshotFile.relativePath);
            }
            this._memoryAnalyzer.showDiffSnapshotTab(snapshotFiles, target, Plugin.Resources.getString("SnapshotNumberDiff", lastSnapshotId, firstSnapshotId));
        };
        SummaryViewController.prototype.setScreenshotSize = function (targetWidth, targetHeight, keepAspectRatio) {
            this._screenshotWidth = targetWidth;
            this._screenshotHeight = targetHeight;
            this._screenshotKeepAspectRatio = keepAspectRatio;
        };
        SummaryViewController.prototype.createTileView = function (snapshotSummary) {
            var model = new MemoryAnalyzer.SnapshotTileViewModel(snapshotSummary, this.model.snapshotSummaryCollection);
            var view = new MemoryAnalyzer.SnapshotTileView(this, model);
            this.model.snapshotSummaryCollection.registerCollectionChanged(view);
            return view;
        };
        SummaryViewController.prototype.reset = function () {
            SummaryViewController.NextIdentifier = 0;
            this.model.snapshotSummaryCollection.clear();
            MemoryAnalyzer.Program.onIdle();
        };
        SummaryViewController.prototype.deleteSnapshot = function () {
            this._memoryAnalyzer.callProxy("deleteSnapshot", [], null);
        };
        SummaryViewController.prototype.getSnapshotSummary = function (snapshotId) {
            var foundSnapshotSummary = null;
            for(var i = 0; i < this.model.snapshotSummaryCollection.length; i++) {
                var snapshotSummary = this.model.snapshotSummaryCollection.getItem(i);
                if(snapshotSummary.id === snapshotId) {
                    foundSnapshotSummary = snapshotSummary;
                    break;
                }
            }
            return foundSnapshotSummary;
        };
        SummaryViewController.prototype.onProcessIdResult = function (processId) {
            this.stopGraph();
            this.view.getHeapGraphContainer().style.display = "block";
            this._heapDataController = new MemoryAnalyzer.HeapDataController(processId, new MemoryAnalyzer.HeapSummaryGraph(this.view.getHeapGraphContainer()));
            this._heapDataController.start();
        };
        SummaryViewController.prototype.onSnapshotResult = function (snapshotFile) {
            var _this = this;
            if(snapshotFile.error) {
                this.onSnapshotFailed(snapshotFile.error);
            } else {
                this._session.addSnapshot(snapshotFile.filePath).done(function (relativePath) {
                    _this.deleteSnapshot();
                    var file = new MemoryAnalyzer.SnapshotFile(_this._storageId, relativePath);
                    file.getSnapshotRawData(function (rawData) {
                        _this.terminateProcessor();
                        _this._snapshotSummaryProcessor = new MemoryAnalyzer.SnapshotSummaryProcessor();
                        _this._snapshotSummaryProcessor.processSnapshotAsync(rawData.data, {
                            completed: _this.onSnapshotCompleted.bind(_this, relativePath, rawData.privateBytes, rawData.base64Image, rawData.pointerSize),
                            failed: _this.onSnapshotFailed.bind(_this)
                        });
                    }, _this.onSnapshotFailed.bind(_this));
                }, this.onSnapshotFailed.bind(this));
            }
        };
        SummaryViewController.prototype.onSnapshotCompleted = function (relativePath, privateBytes, base64Image, pointerSize, snapshotSummary) {
            this.terminateProcessor();
            if(!snapshotSummary) {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1014"));
            }
            var id = ++SummaryViewController.NextIdentifier;
            var heapSize;
            if(this._heapDataController && this._heapDataController.heapGraph.lastItem) {
                heapSize = this._heapDataController.heapGraph.lastItem.heapSizeInBytes;
                this._heapDataController.heapGraph.addSnapshotMarker(new Date(), Plugin.Resources.getString("SnapshotNumber", id));
            }
            var summary = new MemoryAnalyzer.SnapshotSummary(snapshotSummary, new MemoryAnalyzer.SnapshotFile(this._storageId, relativePath), base64Image, privateBytes, pointerSize, heapSize, id);
            this.model.snapshotSummaryCollection.add(summary);
            this.model.isTakingSnapshot = false;
            if(window.console && window.console.log) {
                window.console.log("Snapshot taken: " + summary.objectsCount + " objects totalling " + summary.heapSize + " in the heap.");
            }
            summary.save(MemoryAnalyzer.Program.onIdle, this.onSnapshotFailed.bind(this));
        };
        SummaryViewController.prototype.onSnapshotFailed = function (error) {
            this.terminateProcessor();
            if(!error) {
                throw new Error(Plugin.Resources.getErrorString("JSPerf.1015"));
            }
            error.message = Plugin.Resources.getString("SnapshotCreationFailed", error.message);
            this.model.latestSnapshotError = error;
            this.model.isTakingSnapshot = false;
            MemoryAnalyzer.Program.onIdle();
        };
        SummaryViewController.prototype.terminateProcessor = function () {
            if(this._snapshotSummaryProcessor) {
                this._snapshotSummaryProcessor.terminate();
                this._snapshotSummaryProcessor = null;
            }
        };
        return SummaryViewController;
    })();
    MemoryAnalyzer.SummaryViewController = SummaryViewController;    
    var SummaryViewModel = (function (_super) {
        __extends(SummaryViewModel, _super);
        function SummaryViewModel(isOffline) {
                _super.call(this);
            this._warningMessage = "";
            this._latestSnapshotError = null;
            this._isTakingSnapshot = false;
            this._isAttached = false;
            this._isRunning = true;
            this._isOffline = true;
            this._isOffline = isOffline;
            this._snapshotSummaryCollection = new MemoryAnalyzer.Controls.ObservableCollection();
        }
        Object.defineProperty(SummaryViewModel.prototype, "snapshotSummaryCollection", {
            get: function () {
                return this._snapshotSummaryCollection;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SummaryViewModel.prototype, "isOffline", {
            get: function () {
                return this._isOffline;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SummaryViewModel.prototype, "warningMessage", {
            get: function () {
                return this._warningMessage;
            },
            set: function (v) {
                if(this._warningMessage !== v) {
                    this._warningMessage = v;
                    this.raisePropertyChanged("warningMessage");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SummaryViewModel.prototype, "latestSnapshotError", {
            get: function () {
                return this._latestSnapshotError;
            },
            set: function (v) {
                if(this._latestSnapshotError !== v) {
                    this._latestSnapshotError = v;
                    this.raisePropertyChanged("latestSnapshotError");
                    MemoryAnalyzer.Program.reportError(v, "SnapshotCapturingFailure");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SummaryViewModel.prototype, "isTakingSnapshot", {
            get: function () {
                return this._isTakingSnapshot;
            },
            set: function (v) {
                if(this._isTakingSnapshot !== v) {
                    this._isTakingSnapshot = v;
                    this.raisePropertyChanged("isTakingSnapshot");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SummaryViewModel.prototype, "isAttached", {
            get: function () {
                return this._isAttached;
            },
            set: function (v) {
                if(this._isAttached !== v) {
                    this._isAttached = v;
                    this.raisePropertyChanged("isAttached");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SummaryViewModel.prototype, "isRunning", {
            get: function () {
                return this._isRunning;
            },
            set: function (v) {
                if(this._isRunning !== v) {
                    this._isRunning = v;
                    this.raisePropertyChanged("isRunning");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SummaryViewModel.prototype, "isShowingHeapGraph", {
            get: function () {
                return false;
            },
            enumerable: true,
            configurable: true
        });
        return SummaryViewModel;
    })(MemoryAnalyzer.Controls.ObservableViewModel);
    MemoryAnalyzer.SummaryViewModel = SummaryViewModel;    
    var SummaryView = (function (_super) {
        __extends(SummaryView, _super);
        function SummaryView(controller, model) {
            var _this = this;
                _super.call(this, "SummaryTabTemplate");
            this._screenshotWidth = 280;
            this._screenshotHeight = 160;
            this._screenshotKeepAspectRatio = true;
            this._controller = controller;
            this._model = model;
            this._model.registerPropertyChanged(this);
            this._model.snapshotSummaryCollection.registerCollectionChanged(this);
            this._heapGraphContainer = this.findElement("heapOverviewGraph");
            this._tilesContainer = this.findElement("tilesContainer");
            this._warningSection = this.findElement("warningSection");
            var giveFeedbackButton = this.findElement("giveFeedbackButton_Summary");
            giveFeedbackButton.classList.add("hidden");
            MemoryAnalyzer.Extensions.InternalFeedbackHelper.isEnabled().done(function (isEnabled) {
                if(isEnabled) {
                    giveFeedbackButton.classList.remove("hidden");
                    giveFeedbackButton.addEventListener("click", _this.onGiveFeedbackClick.bind(_this));
                }
            });
            this._takeSnapshotTile = this.findElement("takeSnapshotTile");
            if(this._model.isOffline) {
                this._takeSnapshotTile.style.display = "none";
            } else {
                this._snapshotError = this.findElement("snapshotError");
                this._snapshotErrorMsg = this.findElement("snapshotErrorMsg");
                this._snapshotProgress = this.findElement("takeSnapshotProgress");
                this._snapshotButton = this.findElement("takeSnapshotButton");
                this._snapshotLabel = this.findElement("takeSnapshotLabel");
                this._snapshotIcon = this.findElement("takeSnapshotIcon");
                this._snapshotLabel.innerText = Plugin.Resources.getString("TakeSnapshot");
                this._snapshotProgress.innerText = Plugin.Resources.getString("Loading");
                this.enableSnapshotButton();
                this.toggleProgress(this._model.isTakingSnapshot);
                this.toggleAttached(this._model.isTakingSnapshot, this._model.isAttached, this._model.isRunning);
            }
            this._controller.setScreenshotSize(this._screenshotWidth, this._screenshotHeight, this._screenshotKeepAspectRatio);
        }
        SummaryView.prototype.getHeapGraphContainer = function () {
            return this._heapGraphContainer;
        };
        SummaryView.prototype.onPropertyChanged = function (propertyName) {
            switch(propertyName) {
                case "warningMessage": {
                    this.showWarningMessage(this._model.warningMessage);
                    break;

                }
                case "latestSnapshotError": {
                    this.showSnapshotError(this._model.latestSnapshotError);
                    break;

                }
                case "isTakingSnapshot": {
                    this.toggleProgress(this._model.isTakingSnapshot);
                    break;

                }
                case "isAttached": {
                    this.toggleAttached(this._model.isTakingSnapshot, this._model.isAttached, this._model.isRunning);
                    break;

                }
                case "isRunning": {
                    this.toggleRunning(this._model.isTakingSnapshot, this._model.isRunning);
                    break;

                }
            }
        };
        SummaryView.prototype.onCollectionChanged = function (eventArgs) {
            switch(eventArgs.action) {
                case MemoryAnalyzer.Controls.NotifyCollectionChangedAction.Add: {
                    this.createTile(eventArgs.newItems[0]);
                    break;

                }
                case MemoryAnalyzer.Controls.NotifyCollectionChangedAction.Reset: {
                    this.removeSnapshotTiles();
                    break;

                }
            }
        };
        SummaryView.prototype.onGiveFeedbackClick = function (e) {
            MemoryAnalyzer.Extensions.InternalFeedbackHelper.isEnabled().done(function (enabled) {
                if(enabled) {
                    MemoryAnalyzer.Extensions.Session.save(false).done(function (fileLocation) {
                        MemoryAnalyzer.Extensions.InternalFeedbackHelper.sendData(true, "", "", "", "", fileLocation);
                    });
                }
            });
        };
        SummaryView.prototype.createTile = function (snapshotSummary) {
            var newTile = this._controller.createTileView(snapshotSummary);
            this._tilesContainer.insertBefore(newTile.rootElement, this._takeSnapshotTile);
            newTile.rootElement.scrollIntoView(true);
            newTile.setFocus();
        };
        SummaryView.prototype.enableSnapshotButton = function () {
            this._snapshotButton.addEventListener("click", this.onSnapshotClick.bind(this));
            this._snapshotButton.classList.remove("disabled");
        };
        SummaryView.prototype.disableSnapshotButton = function () {
            this._snapshotButton.removeEventListener("click", this.onSnapshotClick.bind(this));
            this._snapshotButton.classList.add("disabled");
        };
        SummaryView.prototype.removeSnapshotTiles = function () {
            while(this._tilesContainer.hasChildNodes()) {
                this._tilesContainer.removeChild(this._tilesContainer.firstChild);
            }
            this._tilesContainer.appendChild(this._takeSnapshotTile);
        };
        SummaryView.prototype.toggleProgress = function (show) {
            if(this._snapshotButton && this._snapshotProgress && this._snapshotError) {
                if(show) {
                    this.disableSnapshotButton();
                    this._snapshotLabel.style.display = "none";
                    this._snapshotIcon.style.display = "none";
                    this._snapshotProgress.style.display = "block";
                    this._snapshotError.style.display = "none";
                } else {
                    this._model.isAttached ? this.enableSnapshotButton() : this.disableSnapshotButton();
                    this._snapshotLabel.style.display = "";
                    this._snapshotIcon.style.display = "";
                    this._snapshotProgress.style.display = "none";
                }
            }
        };
        SummaryView.prototype.toggleAttached = function (isTakingSnapshot, isAttached, isRunning) {
            if(this._snapshotButton) {
                if(isAttached && isRunning && !isTakingSnapshot) {
                    this.enableSnapshotButton();
                } else {
                    this.disableSnapshotButton();
                }
            }
            if(!isAttached) {
                this._controller.cancelPendingSnapshots();
                this._controller.stopGraph();
            } else {
                this._controller.startGraph();
            }
        };
        SummaryView.prototype.toggleRunning = function (isTakingSnapshot, isRunning) {
            if(isRunning && !isTakingSnapshot) {
                this.enableSnapshotButton();
            } else {
                this.disableSnapshotButton();
            }
        };
        SummaryView.prototype.showSnapshotError = function (error) {
            if(this._snapshotErrorMsg && this._snapshotError) {
                if(error) {
                    this._snapshotErrorMsg.innerText = MemoryAnalyzer.ErrorFormatter.format(error);
                    this._snapshotError.style.display = "block";
                } else {
                    this._snapshotErrorMsg.innerText = "";
                    this._snapshotError.style.display = "none";
                }
            }
        };
        SummaryView.prototype.showWarningMessage = function (warning) {
            if(!this._warningSection) {
                return;
            }
            if(warning) {
                this._warningSection.innerHTML = warning;
                this._warningSection.style.display = "block";
            } else {
                this._warningSection.innerHTML = "";
                this._warningSection.style.display = "none";
            }
        };
        SummaryView.prototype.onSnapshotClick = function (e) {
            this._controller.takeSnapshot();
        };
        return SummaryView;
    })(Common.Controls.TemplateControl);
    MemoryAnalyzer.SummaryView = SummaryView;    
})(MemoryAnalyzer || (MemoryAnalyzer = {}));
//@ sourceMappingURL=summaryView.js.map

// SIG // Begin signature block
// SIG // MIIakwYJKoZIhvcNAQcCoIIahDCCGoACAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFAdOwNw1700v
// SIG // E4w2UhKuRnr9tFi0oIIVeTCCBLowggOioAMCAQICCmEC
// SIG // jkIAAAAAAB8wDQYJKoZIhvcNAQEFBQAwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBMB4XDTEyMDEwOTIyMjU1OFoXDTEz
// SIG // MDQwOTIyMjU1OFowgbMxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // RFNFIEVTTjpGNTI4LTM3NzctOEE3NjElMCMGA1UEAxMc
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJbsjkdN
// SIG // VMJclYDXTgs9v5dDw0vjYGcRLwFNDNjRRi8QQN4LpFBS
// SIG // EogLQ3otP+5IbmbHkeYDym7sealqI5vNYp7NaqQ/56ND
// SIG // /2JHobS6RPrfQMGFVH7ooKcsQyObUh8yNfT+mlafjWN3
// SIG // ezCeCjOFchvKSsjMJc3bXREux7CM8Y9DSEcFtXogC+Xz
// SIG // 78G69LPYzTiP+yGqPQpthRfQyueGA8Azg7UlxMxanMTD
// SIG // 2mIlTVMlFGGP+xvg7PdHxoBF5jVTIzZ3yrDdmCs5wHU1
// SIG // D92BTCE9djDFsrBlcylIJ9jC0rCER7t4utV0A97XSxn3
// SIG // U9542ob3YYgmM7RHxqBUiBUrLHUCAwEAAaOCAQkwggEF
// SIG // MB0GA1UdDgQWBBQv6EbIaNNuT7Ig0N6JTvFH7kjB8jAf
// SIG // BgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7syuwwzWzDzBU
// SIG // BgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsGAQUFBwEBBEww
// SIG // SjBIBggrBgEFBQcwAoY8aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRUaW1lU3Rh
// SIG // bXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQBz/30unc2NiCt8feNeFXHp
// SIG // aGLwCLZDVsRcSi1o2PlIEZHzEZyF7BLUVKB1qTihWX91
// SIG // 7sb1NNhUpOLQzHyXq5N1MJcHHQRTLDZ/f/FAHgybgOIS
// SIG // CiA6McAHdWfg+jSc7Ij7VxzlWGIgkEUvXUWpyI6zfHJt
// SIG // ECfFS9hvoqgSs201I2f6LNslLbldsR4F50MoPpwFdnfx
// SIG // Jd4FRxlt3kmFodpKSwhGITWodTZMt7MIqt+3K9m+Kmr9
// SIG // 3zUXzD8Mx90Gz06UJGMgCy4krl9DRBJ6XN0326RFs5E6
// SIG // Eld940fGZtPPnEZW9EwHseAMqtX21Tyi4LXU+Bx+BFUQ
// SIG // axj0kc1Rp5VlMIIE7DCCA9SgAwIBAgITMwAAALARrwqL
// SIG // 0Duf3QABAAAAsDANBgkqhkiG9w0BAQUFADB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQTAeFw0xMzAxMjQyMjMzMzla
// SIG // Fw0xNDA0MjQyMjMzMzlaMIGDMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYDVQQDExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQDor1yiIA34KHy8BXt/re7r
// SIG // dqwoUz8620B9s44z5lc/pVEVNFSlz7SLqT+oN+EtUO01
// SIG // Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Unm/P4LZ5BNisL
// SIG // QPu+O7q5XHWTFlJLyjPFN7Dz636o9UEVXAhlHSE38Cy6
// SIG // IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpOoPXJCiHiquMB
// SIG // Nkf9L4JqgQP1qTXclFed+0vUDoLbOI8S/uPWenSIZOFi
// SIG // xCUuKq6dGB8OHrbCryS0DlC83hyTXEmmebW22875cHso
// SIG // AYS4KinPv6kFBeHgD3FN/a1cI4Mp68fFSsjoJ4TTfsZD
// SIG // C5UABbFPZXHFAgMBAAGjggFgMIIBXDATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGmWjNN2pgHgP+E
// SIG // Hr6H+XIyQfIwUQYDVR0RBEowSKRGMEQxDTALBgNVBAsT
// SIG // BE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRmYWYwYjcxLWFk
// SIG // MzctNGFhMy1hNjcxLTc2YmMwNTIzNDRhZDAfBgNVHSME
// SIG // GDAWgBTLEejK0rQWWAHJNy4zFha5TJoKHzBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0Ff
// SIG // MDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8wOC0zMS0y
// SIG // MDEwLmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMdduKhJX
// SIG // M4HVncbr+TrURE0Inu5e32pbt3nPApy8dmiekKGcC8N/
// SIG // oozxTbqVOfsN4OGb9F0kDxuNiBU6fNutzrPJbLo5LEV9
// SIG // JBFUJjANDf9H6gMH5eRmXSx7nR2pEPocsHTyT2lrnqkk
// SIG // hNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2yRPnwPJNtQtjo
// SIG // fOYXoJtoaAko+QKX7xEDumdSrcHps3Om0mPNSuI+5PNO
// SIG // /f+h4LsCEztdIN5VP6OukEAxOHUoXgSpRm3m9Xp5QL0f
// SIG // zehF1a7iXT71dcfmZmNgzNWahIeNJDD37zTQYx2xQmdK
// SIG // Dku/Og7vtpU6pzjkJZIIpohmgjCCBbwwggOkoAMCAQIC
// SIG // CmEzJhoAAAAAADEwDQYJKoZIhvcNAQEFBQAwXzETMBEG
// SIG // CgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixkARkW
// SIG // CW1pY3Jvc29mdDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJv
// SIG // b3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MB4XDTEwMDgz
// SIG // MTIyMTkzMloXDTIwMDgzMTIyMjkzMloweTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENv
// SIG // ZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCycllcGTBkvx2aYCAgQpl2U2w+
// SIG // G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/3sJCTiPVcgDb
// SIG // NVcKicquIEn08GisTUuNpb15S3GbRwfa/SXfnXWIz6pz
// SIG // RH/XgdvzvfI2pMlcRdyvrT3gKGiXGqelcnNW8ReU5P01
// SIG // lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJpL9oZC/6SdCni
// SIG // di9U3RQwWfjSjWL9y8lfRjFQuScT5EAwz3IpECgixzdO
// SIG // PaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn0i1i8UU956wI
// SIG // APZGoZ7RW4wmU+h6qkryRs83PDietHdcpReejcsRj1Y8
// SIG // wawJXwPTAgMBAAGjggFeMIIBWjAPBgNVHRMBAf8EBTAD
// SIG // AQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGCNxUBBAUCAwEA
// SIG // ATAjBgkrBgEEAYI3FQIEFgQU/dExTtMmipXhmGA7qDFv
// SIG // pjy82C0wGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // HwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8KuEKU5VZ5KQw
// SIG // UAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvbWljcm9z
// SIG // b2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUFBwEBBEgwRjBE
// SIG // BggrBgEFBQcwAoY4aHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNyb3NvZnRSb290Q2VydC5j
// SIG // cnQwDQYJKoZIhvcNAQEFBQADggIBAFk5Pn8mRq/rb0Cx
// SIG // MrVq6w4vbqhJ9+tfde1MOy3XQ60L/svpLTGjI8x8UJiA
// SIG // IV2sPS9MuqKoVpzjcLu4tPh5tUly9z7qQX/K4QwXacul
// SIG // nCAt+gtQxFbNLeNK0rxw56gNogOlVuC4iktX8pVCnPHz
// SIG // 7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y4k74jKHK6BOl
// SIG // kU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wdzaKMvSeyeWNW
// SIG // RKJRzfnpo1hW3ZsCRUQvX/TartSCMm78pJUT5Otp56mi
// SIG // LL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q70eFW6NB4lhhc
// SIG // yTUWX92THUmOLb6tNEQc7hAVGgBd3TVbIc6YxwnuhQ6M
// SIG // T20OE049fClInHLR82zKwexwo1eSV32UjaAbSANa98+j
// SIG // Zwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKNMxZlHg6K3RDe
// SIG // ZPRvzkbU0xfpecQEtNP7LN8fip6sCvsTJ0Ct5PnhqX9G
// SIG // uwdgR2VgQE6wQuxO7bN2edgKNAltHIAxH+IOVN3lofvl
// SIG // RxCtZJj/UBYufL8FIXrilUEnacOTj5XJjdibIa4NXJzw
// SIG // oq6GaIMMai27dmsAHZat8hZ79haDJLmIz2qoRzEvmtzj
// SIG // cT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq/2mbluIQqBC0
// SIG // N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZoNAAAAAAAHDAN
// SIG // BgkqhkiG9w0BAQUFADBfMRMwEQYKCZImiZPyLGQBGRYD
// SIG // Y29tMRkwFwYKCZImiZPyLGQBGRYJbWljcm9zb2Z0MS0w
// SIG // KwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0
// SIG // ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1MzA5WhcNMjEw
// SIG // NDAzMTMwMzA5WjB3MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEw
// SIG // HwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Ew
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCf
// SIG // oWyx39tIkip8ay4Z4b3i48WZUSNQrc7dGE4kD+7Rp9FM
// SIG // rXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr6Hu97IkHD/cO
// SIG // BJjwicwfyzMkh53y9GccLPx754gd6udOo6HBI1PKjfpF
// SIG // zwnQXq/QsEIEovmmbJNn1yjcRlOwhtDlKEYuJ6yGT1VS
// SIG // DOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd++NIT8wi3U21S
// SIG // tEWQn0gASkdmEScpZqiX5NMGgUqi+YSnEUcUCYKfhO1V
// SIG // eP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68eeEExd8yb3zuD
// SIG // k6FhArUdDbH895uyAc4iS1T/+QXDwiALAgMBAAGjggGr
// SIG // MIIBpzAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQj
// SIG // NPjZUkZwCu1A+3b7syuwwzWzDzALBgNVHQ8EBAMCAYYw
// SIG // EAYJKwYBBAGCNxUBBAMCAQAwgZgGA1UdIwSBkDCBjYAU
// SIG // DqyCYEBWJ5flJRP8KuEKU5VZ5KShY6RhMF8xEzARBgoJ
// SIG // kiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZFglt
// SIG // aWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290
// SIG // IENlcnRpZmljYXRlIEF1dGhvcml0eYIQea0WoUqgpa1M
// SIG // c1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9taWNyb3NvZnRyb290Y2VydC5jcmwwVAYIKwYBBQUH
// SIG // AQEESDBGMEQGCCsGAQUFBzAChjhodHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFJv
// SIG // b3RDZXJ0LmNydDATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wDRDbd6bStd9vO
// SIG // eVFNAbEudHFbbQwTq86+e4+4LtQSooxtYrhXAstOIBNQ
// SIG // md16QOJXu69YmhzhHQGGrLt48ovQ7DsB7uK+jwoFyI1I
// SIG // 4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mRKiQicPv2/OR4
// SIG // mS4N9wficLwYTp2OawpylbihOZxnLcVRDupiXD8WmIsg
// SIG // P+IHGjL5zDFKdjE9K3ILyOpwPf+FChPfwgphjvDXuBfr
// SIG // Tot/xTUrXqO/67x9C0J71FNyIe4wyrt4ZVxbARcKFA7S
// SIG // 2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGysOUzU9nm/qhh6
// SIG // YinvopspNAZ3GmLJPR5tH4LwC8csu89Ds+X57H2146So
// SIG // dDW4TsVxIxImdgs8UoxxWkZDFLyzs7BNZ8ifQv+AeSGA
// SIG // nhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU2DKATCYqSCRf
// SIG // WupW76bemZ3KOm+9gSd0BhHudiG/m4LBJ1S2sWo9iaF2
// SIG // YbRuoROmv6pH8BJv/YoybLL+31HIjCPJZr2dHYcSZAI9
// SIG // La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCleKuzoJZ1GtmS
// SIG // hxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/Jmu5J4PcBZW+J
// SIG // C33Iacjmbuqnl84xKf8OxVtc2E0bodj6L54/LlUWa8kT
// SIG // o/0xggSGMIIEggIBATCBkDB5MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWdu
// SIG // aW5nIFBDQQITMwAAALARrwqL0Duf3QABAAAAsDAJBgUr
// SIG // DgMCGgUAoIGoMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3
// SIG // AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEV
// SIG // MCMGCSqGSIb3DQEJBDEWBBSbRbGyVyUFIn8ACvSxDojv
// SIG // Nez4TDBIBgorBgEEAYI3AgEMMTowOKAegBwAcwB1AG0A
// SIG // bQBhAHIAeQBWAGkAZQB3AC4AagBzoRaAFGh0dHA6Ly9t
// SIG // aWNyb3NvZnQuY29tMA0GCSqGSIb3DQEBAQUABIIBACyt
// SIG // ZTGQbJuUd1MZqQ3emgZ8DLVqrEMw5MnNEZNCax9FHsfM
// SIG // Ez3zPpvr0yhkxzYX+fP+0qlG0G7gcze3KGptga/8epzt
// SIG // WfYa5UCBnLK7nEMPT1EoU5EIBMHSLzZFLbKKB1TZThrO
// SIG // d/wkltgZWHwgjaTHi0hwIfS51GKTQpqv6btGbLqJJilG
// SIG // qj5Xzdcfs5/jprv11mpTKTxOSp39Bn6fuiPt11av6QZc
// SIG // v7ZOJ4FSBF+H4B5f2QSJkauE9SBNRAUlDB7E4FZqhSL2
// SIG // /Q2cgg2QDZJtu7fwxv9EQS+++qC4vaYpJcS6Af/qEFQ0
// SIG // w0q8bbbngM02U3MRHhvkyhtSYT0ti/ehggIfMIICGwYJ
// SIG // KoZIhvcNAQkGMYICDDCCAggCAQEwgYUwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBAgphAo5CAAAAAAAfMAkGBSsOAwIa
// SIG // BQCgXTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwG
// SIG // CSqGSIb3DQEJBTEPFw0xMzAzMTUwNjMzNTlaMCMGCSqG
// SIG // SIb3DQEJBDEWBBRO5dqrPQAcLfpYuzp04/IHxyq3ETAN
// SIG // BgkqhkiG9w0BAQUFAASCAQBFgg3A1teavgKM+JjyYoZV
// SIG // KcDOQqtUkp+dNx/8g78QgWUOOgJiuAw19Yo/f/n8uKNs
// SIG // 2buQx6pI4ReF+0bH5V4wXqBrQzItf/WytIHjT9Ru+cw6
// SIG // d+QW3DdWCWRSMhz62YUIQBpCEA1sMuYo4JmhhlWRvYtS
// SIG // zyS5lfu0/Jt90oYpV148acA0vaY6VU4KcBvIZRoKtCnc
// SIG // A3HzierMhKAcufXsn+5gOGtVZIaxHJmJvghwu4E1x9HD
// SIG // Iy7oEUJzG7CYSRvdjMuMdQjgfDx/mL9RR/9NPdYy4X11
// SIG // pPvb+vhEzAhWrll2U5OYCQqH6YeNGJiSrMuPQopNil8M
// SIG // SUCD6Duba1p6
// SIG // End signature block
